classdef statManager < handle
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    
    properties
        data;
        sum;
        count;
        mean;
        SD;
        SE;
        CI83;
        CI95;
        CI99;
        flgHarmonic;
        type;
        
    end
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    
    methods
        function sm = statManager(data, flgHarmonic, type)
            sm.flgHarmonic = flgHarmonic;
            sm.type = type;
            
            if iscell(data)
                if flgHarmonic
                    sm.mean = cellfun(@harmmean, data);
                    sm.SD = cellfun(@(x) jackknife(x), data);
                else
                    sm.mean = cellfun(@mean, data);
                    sm.SD = cellfun(@(x) std(x), data);
                end
                sm.sum = cellfun(@sum, data);
                sm.count = cellfun(@(x) numel(x), data);
                
            else
                if flgHarmonic
                    sm.mean = harmmean(data, 1);
                    sm.SD = jackknife(data);
                else
                    sm.mean = mean(data, 1);
                    sm.SD = std(data, 0, 1);
                end
                sm.sum = sum(data, 1);
                sm.count = size(data, 1);
                
            end

            sm.data = data;
            sm.SE = sm.SD ./ sqrt(sm.count);
            sm.CI83 = sm.SE .* 1.386;                 % For 83.4% CI that would match P = 0.05
            sm.CI95 = sm.SE .* 1.96;
            sm.CI99 = sm.SE .* 2.58;
            
            if isempty(sm.data)
                sm.data = nan;
                sm.mean = nan;
                sm.count = nan;
                sm.sum = nan;
            end
        end
    end
    
end
